# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Export a design package
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# URL to the SharePoint site collection
$siteUrl = "http://sharepoint/sitecollection"

# Folder to save the design package
$outputPath = "C:\Packages\"

# Name of the design package
$packageName = "My PowerShell Design"

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Load the required SharePoint assemblies
[Reflection.Assembly]::LoadFrom("C:\Program Files\Common Files\microsoft shared\Web Server Extensions\15\ISAPI\Microsoft.SharePoint.Publishing.dll")
[Reflection.Assembly]::LoadFrom("C:\Program Files\Common Files\microsoft shared\Web Server Extensions\15\ISAPI\Microsoft.SharePoint.dll")

# Get the site collection
$site = Get-SPSite $siteUrl

# Create the design package
$package = [Microsoft.SharePoint.Publishing.DesignPackage]::Export($site, $packageName, $false)

# Construct the file name from the design package details
$fileName = "{0}-{1}.{2}.wsp" f ($package.PackageName, $package.MajorVersion, $package.MinorVersion)

# Get the content of the design package File
$fileBinary = $site.RootWeb.GetFile("/_catalogs/solutions/" + $fileName).OpenBinary()

# Save the design package file to the output folder
$fileStream = New-Object System.IO.FileStream($outputPath + $fileName, [System.IO.FileMode]::OpenOrCreate, [System.IO.FileAccess]::Write) 
$fileStream.Write($fileBinary, 0, $fileBinary.Length)
$fileStream.Close()

# Dispose of the site collection object
$site.Dispose()

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 